/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.utils;

import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.utils.ConcurrentHashMapV8;
import org.glassfish.grizzly.utils.JdkVersion;

public class DataStructures {
    private static final Class<?> LTQclass;

    private static Class<?> getAndVerify(String cname) throws Throwable {
        return DataStructures.class.getClassLoader().loadClass(cname).newInstance().getClass();
    }

    public static <T> BlockingQueue<T> getLTQInstance() {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    public static <T> BlockingQueue<T> getLTQInstance(Class<T> t) {
        try {
            return (BlockingQueue)LTQclass.newInstance();
        }
        catch (Exception ea) {
            throw new RuntimeException(ea);
        }
    }

    public static <K, V> ConcurrentMap<K, V> getConcurrentMap() {
        return (ConcurrentMap)((Object)(JdkVersion.getJdkVersion().isUnsafeSupported() ? new ConcurrentHashMapV8() : new ConcurrentHashMap()));
    }

    public static <K, V> ConcurrentMap<K, V> getConcurrentMap(Map<? extends K, ? extends V> map2) {
        return (ConcurrentMap)((Object)(JdkVersion.getJdkVersion().isUnsafeSupported() ? new ConcurrentHashMapV8<K, V>(map2) : new ConcurrentHashMap<K, V>(map2)));
    }

    public static <K, V> ConcurrentMap<K, V> getConcurrentMap(int initialCapacity) {
        return (ConcurrentMap)((Object)(JdkVersion.getJdkVersion().isUnsafeSupported() ? new ConcurrentHashMapV8(initialCapacity) : new ConcurrentHashMap(initialCapacity)));
    }

    public static <K, V> ConcurrentMap<K, V> getConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return (ConcurrentMap)((Object)(JdkVersion.getJdkVersion().isUnsafeSupported() ? new ConcurrentHashMapV8(initialCapacity, loadFactor, concurrencyLevel) : new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel)));
    }

    static {
        Class<Object> c;
        String className = null;
        try {
            JdkVersion jdkVersion = JdkVersion.getJdkVersion();
            JdkVersion minimumVersion = JdkVersion.parseVersion("1.7.0");
            className = minimumVersion.compareTo(jdkVersion) <= 0 ? "java.util.concurrent.LinkedTransferQueue" : "org.glassfish.grizzly.utils.LinkedTransferQueue";
            c = DataStructures.getAndVerify(className);
            Grizzly.logger(DataStructures.class).log(Level.FINE, "USING LTQ class:{0}", c);
        }
        catch (Throwable t) {
            Grizzly.logger(DataStructures.class).log(Level.FINE, "failed loading datastructure class:" + className + " fallback to embedded one", t);
            c = LinkedBlockingQueue.class;
        }
        LTQclass = c;
    }
}

